	function [comp, instid] = hdladdinstance(comp, inst, gmap)
	%[comp, instid] = hdladdinstance(comp, inst[, gmap])
	
	%Copyright 2010 Anton Blad
	
	%This file is part of vhdlgen.
	
	%vhdlgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	
	%vhdlgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	
	%You should have received a copy of the GNU General Public License
	%along with vhdlgen.  If not, see <http://www.gnu.org/licenses/>.
	
	if nargin < 3
		gmap = [];
	end
	
	kinst = length(comp.arch.instances)+1;
	instid = sprintf('i%d', kinst);
	
	comp.arch.instances(kinst).type = inst.iface.name;
	comp.arch.instances(kinst).generics = gmap;
	comp.arch.instances(kinst).inputs = [];
	comp.arch.instances(kinst).outputs = [];
	
	ksig = length(comp.arch.signals);
	
	for kin = 1:length(inst.iface.inputs)
		sig = strcat(instid, '_', inst.iface.inputs(kin).name);
	
		comp.arch.instances(kinst).inputs(kin).class = 1;
		comp.arch.instances(kinst).inputs(kin).formal = inst.iface.inputs(kin).name;
		comp.arch.instances(kinst).inputs(kin).actual.ref = sig;
	
		ksig = ksig + 1;
		comp.arch.signals(ksig).name = sig;
		comp.arch.signals(ksig).type = inst.iface.inputs(kin).type;
	end
	
	for kout = 1:length(inst.iface.outputs)
		sig = strcat(instid, '_', inst.iface.outputs(kout).name);
	
		comp.arch.instances(kinst).outputs(kout).class = 1;
		comp.arch.instances(kinst).outputs(kout).formal = inst.iface.outputs(kout).name;
		comp.arch.instances(kinst).outputs(kout).actual.ref = sig;
	
		ksig = ksig + 1;
		comp.arch.signals(ksig).name = sig;
		comp.arch.signals(ksig).type = inst.iface.outputs(kout).type;
	end
	
